function [Ctup,FTup,Nup,Qaltup,Ctdown,FTdown,Ndown,Qaltdown]...
    = forces(c,dens,Clup,Cdup,Cmup,Wup,dd,Cldown,Cddown,Cmdown,Wdown,...
    aup,adown)
Ctup = (Clup*sin(aup)-Cdup*cos(aup));
Ctdown = (Cldown*sin(adown)-Cddown*cos(adown));
Lup = 0.5*c*dens*Clup*Wup^2/cos(dd);
Dup = 0.5*c*dens*Cdup*Wup^2/cos(dd);
Nup = Lup*cos(aup)+Dup*sin(aup);
FTup = Lup*sin(aup)-Dup*cos(aup);
Qaltup = 0.5*Cmup*(c*dens)*c/cos(dd)*Wup^2;
Ldown = 0.5*c*dens*Cldown*Wdown^2/cos(dd);
Ddown = 0.5*c*dens*Cddown*Wdown^2/cos(dd);
Ndown = Ldown*cos(adown)+Ddown*sin(adown);
FTdown = Ldown*sin(adown)-Ddown*cos(adown);
Qaltdown = 0.5*Cmdown*(c*dens)*c/cos(dd)*Wdown^2;
if isnan(FTup)
    FTup = 0;
end
if isnan(Nup)
    Nup = 0;
end
if isnan(FTdown)
    FTdown = 0;
end
if isnan(Ndown)
    Ndown = 0;
end
end